package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProductDiscountSortOrder {
  private String sortOrder;

  public ChangeProductDiscountSortOrder() {
  }

  public ChangeProductDiscountSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  public String getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  @Override
  public String toString() {
    return "ChangeProductDiscountSortOrder{sortOrder='" + sortOrder + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProductDiscountSortOrder that = (ChangeProductDiscountSortOrder) o;
    return Objects.equals(sortOrder, that.sortOrder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sortOrder);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sortOrder;

    public ChangeProductDiscountSortOrder build() {
      ChangeProductDiscountSortOrder result = new ChangeProductDiscountSortOrder();
      result.sortOrder = this.sortOrder;
      return result;
    }

    public Builder sortOrder(String sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }
  }
}
