package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProductImageLabel {
  private Integer variantId;

  private String sku;

  private String imageUrl;

  private String label;

  private Boolean staged = true;

  public ChangeProductImageLabel() {
  }

  public ChangeProductImageLabel(Integer variantId, String sku, String imageUrl, String label,
      Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.imageUrl = imageUrl;
    this.label = label;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getImageUrl() {
    return imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "ChangeProductImageLabel{variantId='" + variantId + "', sku='" + sku + "', imageUrl='" + imageUrl + "', label='" + label + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProductImageLabel that = (ChangeProductImageLabel) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(imageUrl, that.imageUrl) &&
        Objects.equals(label, that.label) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, imageUrl, label, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private String imageUrl;

    private String label;

    private Boolean staged = true;

    public ChangeProductImageLabel build() {
      ChangeProductImageLabel result = new ChangeProductImageLabel();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.imageUrl = this.imageUrl;
      result.label = this.label;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder imageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
