package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeProductSlug {
  private List<LocalizedStringItemInputType> slug;

  private Boolean staged = true;

  public ChangeProductSlug() {
  }

  public ChangeProductSlug(List<LocalizedStringItemInputType> slug, Boolean staged) {
    this.slug = slug;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "ChangeProductSlug{slug='" + slug + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProductSlug that = (ChangeProductSlug) o;
    return Objects.equals(slug, that.slug) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(slug, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> slug;

    private Boolean staged = true;

    public ChangeProductSlug build() {
      ChangeProductSlug result = new ChangeProductSlug();
      result.slug = this.slug;
      result.staged = this.staged;
      return result;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
