package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class ChangeProjectSettingsBusinessUnitSearchStatus {
  private BusinessUnitSearchStatus status;

  public ChangeProjectSettingsBusinessUnitSearchStatus() {
  }

  public ChangeProjectSettingsBusinessUnitSearchStatus(BusinessUnitSearchStatus status) {
    this.status = status;
  }

  public BusinessUnitSearchStatus getStatus() {
    return status;
  }

  public void setStatus(BusinessUnitSearchStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsBusinessUnitSearchStatus{status='" + status + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsBusinessUnitSearchStatus that = (ChangeProjectSettingsBusinessUnitSearchStatus) o;
    return Objects.equals(status, that.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitSearchStatus status;

    public ChangeProjectSettingsBusinessUnitSearchStatus build() {
      ChangeProjectSettingsBusinessUnitSearchStatus result = new ChangeProjectSettingsBusinessUnitSearchStatus();
      result.status = this.status;
      return result;
    }

    public Builder status(BusinessUnitSearchStatus status) {
      this.status = status;
      return this;
    }
  }
}
