package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsCartsConfiguration {
  private CartsConfigurationInput cartsConfiguration;

  public ChangeProjectSettingsCartsConfiguration() {
  }

  public ChangeProjectSettingsCartsConfiguration(CartsConfigurationInput cartsConfiguration) {
    this.cartsConfiguration = cartsConfiguration;
  }

  public CartsConfigurationInput getCartsConfiguration() {
    return cartsConfiguration;
  }

  public void setCartsConfiguration(CartsConfigurationInput cartsConfiguration) {
    this.cartsConfiguration = cartsConfiguration;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsCartsConfiguration{cartsConfiguration='" + cartsConfiguration + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsCartsConfiguration that = (ChangeProjectSettingsCartsConfiguration) o;
    return Objects.equals(cartsConfiguration, that.cartsConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartsConfiguration);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartsConfigurationInput cartsConfiguration;

    public ChangeProjectSettingsCartsConfiguration build() {
      ChangeProjectSettingsCartsConfiguration result = new ChangeProjectSettingsCartsConfiguration();
      result.cartsConfiguration = this.cartsConfiguration;
      return result;
    }

    public Builder cartsConfiguration(CartsConfigurationInput cartsConfiguration) {
      this.cartsConfiguration = cartsConfiguration;
      return this;
    }
  }
}
