package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeProjectSettingsCountries {
  private List<String> countries;

  public ChangeProjectSettingsCountries() {
  }

  public ChangeProjectSettingsCountries(List<String> countries) {
    this.countries = countries;
  }

  public List<String> getCountries() {
    return countries;
  }

  public void setCountries(List<String> countries) {
    this.countries = countries;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsCountries{countries='" + countries + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsCountries that = (ChangeProjectSettingsCountries) o;
    return Objects.equals(countries, that.countries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(countries);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> countries;

    public ChangeProjectSettingsCountries build() {
      ChangeProjectSettingsCountries result = new ChangeProjectSettingsCountries();
      result.countries = this.countries;
      return result;
    }

    public Builder countries(List<String> countries) {
      this.countries = countries;
      return this;
    }
  }
}
