package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsCustomerSearchStatus {
  private CustomerSearchStatus status;

  public ChangeProjectSettingsCustomerSearchStatus() {
  }

  public ChangeProjectSettingsCustomerSearchStatus(CustomerSearchStatus status) {
    this.status = status;
  }

  public CustomerSearchStatus getStatus() {
    return status;
  }

  public void setStatus(CustomerSearchStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsCustomerSearchStatus{status='" + status + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsCustomerSearchStatus that = (ChangeProjectSettingsCustomerSearchStatus) o;
    return Objects.equals(status, that.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerSearchStatus status;

    public ChangeProjectSettingsCustomerSearchStatus build() {
      ChangeProjectSettingsCustomerSearchStatus result = new ChangeProjectSettingsCustomerSearchStatus();
      result.status = this.status;
      return result;
    }

    public Builder status(CustomerSearchStatus status) {
      this.status = status;
      return this;
    }
  }
}
