package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsMessagesConfiguration {
  private MessagesConfigurationDraft messagesConfiguration;

  public ChangeProjectSettingsMessagesConfiguration() {
  }

  public ChangeProjectSettingsMessagesConfiguration(
      MessagesConfigurationDraft messagesConfiguration) {
    this.messagesConfiguration = messagesConfiguration;
  }

  public MessagesConfigurationDraft getMessagesConfiguration() {
    return messagesConfiguration;
  }

  public void setMessagesConfiguration(MessagesConfigurationDraft messagesConfiguration) {
    this.messagesConfiguration = messagesConfiguration;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsMessagesConfiguration{messagesConfiguration='" + messagesConfiguration + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsMessagesConfiguration that = (ChangeProjectSettingsMessagesConfiguration) o;
    return Objects.equals(messagesConfiguration, that.messagesConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messagesConfiguration);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MessagesConfigurationDraft messagesConfiguration;

    public ChangeProjectSettingsMessagesConfiguration build() {
      ChangeProjectSettingsMessagesConfiguration result = new ChangeProjectSettingsMessagesConfiguration();
      result.messagesConfiguration = this.messagesConfiguration;
      return result;
    }

    public Builder messagesConfiguration(MessagesConfigurationDraft messagesConfiguration) {
      this.messagesConfiguration = messagesConfiguration;
      return this;
    }
  }
}
