package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsMessagesEnabled {
  private Boolean messagesEnabled;

  public ChangeProjectSettingsMessagesEnabled() {
  }

  public ChangeProjectSettingsMessagesEnabled(Boolean messagesEnabled) {
    this.messagesEnabled = messagesEnabled;
  }

  public Boolean getMessagesEnabled() {
    return messagesEnabled;
  }

  public void setMessagesEnabled(Boolean messagesEnabled) {
    this.messagesEnabled = messagesEnabled;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsMessagesEnabled{messagesEnabled='" + messagesEnabled + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsMessagesEnabled that = (ChangeProjectSettingsMessagesEnabled) o;
    return Objects.equals(messagesEnabled, that.messagesEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messagesEnabled);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean messagesEnabled;

    public ChangeProjectSettingsMessagesEnabled build() {
      ChangeProjectSettingsMessagesEnabled result = new ChangeProjectSettingsMessagesEnabled();
      result.messagesEnabled = this.messagesEnabled;
      return result;
    }

    public Builder messagesEnabled(Boolean messagesEnabled) {
      this.messagesEnabled = messagesEnabled;
      return this;
    }
  }
}
