package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsOrderSearchStatus {
  private OrderSearchStatus status;

  public ChangeProjectSettingsOrderSearchStatus() {
  }

  public ChangeProjectSettingsOrderSearchStatus(OrderSearchStatus status) {
    this.status = status;
  }

  public OrderSearchStatus getStatus() {
    return status;
  }

  public void setStatus(OrderSearchStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsOrderSearchStatus{status='" + status + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsOrderSearchStatus that = (ChangeProjectSettingsOrderSearchStatus) o;
    return Objects.equals(status, that.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OrderSearchStatus status;

    public ChangeProjectSettingsOrderSearchStatus build() {
      ChangeProjectSettingsOrderSearchStatus result = new ChangeProjectSettingsOrderSearchStatus();
      result.status = this.status;
      return result;
    }

    public Builder status(OrderSearchStatus status) {
      this.status = status;
      return this;
    }
  }
}
