package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeShoppingListLineItemsOrder {
  private List<String> lineItemOrder;

  public ChangeShoppingListLineItemsOrder() {
  }

  public ChangeShoppingListLineItemsOrder(List<String> lineItemOrder) {
    this.lineItemOrder = lineItemOrder;
  }

  public List<String> getLineItemOrder() {
    return lineItemOrder;
  }

  public void setLineItemOrder(List<String> lineItemOrder) {
    this.lineItemOrder = lineItemOrder;
  }

  @Override
  public String toString() {
    return "ChangeShoppingListLineItemsOrder{lineItemOrder='" + lineItemOrder + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeShoppingListLineItemsOrder that = (ChangeShoppingListLineItemsOrder) o;
    return Objects.equals(lineItemOrder, that.lineItemOrder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemOrder);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> lineItemOrder;

    public ChangeShoppingListLineItemsOrder build() {
      ChangeShoppingListLineItemsOrder result = new ChangeShoppingListLineItemsOrder();
      result.lineItemOrder = this.lineItemOrder;
      return result;
    }

    public Builder lineItemOrder(List<String> lineItemOrder) {
      this.lineItemOrder = lineItemOrder;
      return this;
    }
  }
}
