package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeShoppingListTextLineItemQuantity {
  private String textLineItemId;

  private String textLineItemKey;

  private Integer quantity;

  public ChangeShoppingListTextLineItemQuantity() {
  }

  public ChangeShoppingListTextLineItemQuantity(String textLineItemId, String textLineItemKey,
      Integer quantity) {
    this.textLineItemId = textLineItemId;
    this.textLineItemKey = textLineItemKey;
    this.quantity = quantity;
  }

  public String getTextLineItemId() {
    return textLineItemId;
  }

  public void setTextLineItemId(String textLineItemId) {
    this.textLineItemId = textLineItemId;
  }

  public String getTextLineItemKey() {
    return textLineItemKey;
  }

  public void setTextLineItemKey(String textLineItemKey) {
    this.textLineItemKey = textLineItemKey;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "ChangeShoppingListTextLineItemQuantity{textLineItemId='" + textLineItemId + "', textLineItemKey='" + textLineItemKey + "', quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeShoppingListTextLineItemQuantity that = (ChangeShoppingListTextLineItemQuantity) o;
    return Objects.equals(textLineItemId, that.textLineItemId) &&
        Objects.equals(textLineItemKey, that.textLineItemKey) &&
        Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(textLineItemId, textLineItemKey, quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String textLineItemId;

    private String textLineItemKey;

    private Integer quantity;

    public ChangeShoppingListTextLineItemQuantity build() {
      ChangeShoppingListTextLineItemQuantity result = new ChangeShoppingListTextLineItemQuantity();
      result.textLineItemId = this.textLineItemId;
      result.textLineItemKey = this.textLineItemKey;
      result.quantity = this.quantity;
      return result;
    }

    public Builder textLineItemId(String textLineItemId) {
      this.textLineItemId = textLineItemId;
      return this;
    }

    public Builder textLineItemKey(String textLineItemKey) {
      this.textLineItemKey = textLineItemKey;
      return this;
    }

    public Builder quantity(Integer quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
