package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStagedOrderCustomLineItemMoney {
  private String customLineItemId;

  private String customLineItemKey;

  private BaseMoneyInput money;

  public ChangeStagedOrderCustomLineItemMoney() {
  }

  public ChangeStagedOrderCustomLineItemMoney(String customLineItemId, String customLineItemKey,
      BaseMoneyInput money) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.money = money;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public BaseMoneyInput getMoney() {
    return money;
  }

  public void setMoney(BaseMoneyInput money) {
    this.money = money;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderCustomLineItemMoney{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', money='" + money + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderCustomLineItemMoney that = (ChangeStagedOrderCustomLineItemMoney) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(money, that.money);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, money);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private BaseMoneyInput money;

    public ChangeStagedOrderCustomLineItemMoney build() {
      ChangeStagedOrderCustomLineItemMoney result = new ChangeStagedOrderCustomLineItemMoney();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.money = this.money;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder money(BaseMoneyInput money) {
      this.money = money;
      return this;
    }
  }
}
