package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderCustomLineItemMoneyOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customLineItemId;

  private String customLineItemKey;

  private BaseMoney money;

  public ChangeStagedOrderCustomLineItemMoneyOutput() {
  }

  public ChangeStagedOrderCustomLineItemMoneyOutput(String type, String customLineItemId,
      String customLineItemKey, BaseMoney money) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.money = money;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public BaseMoney getMoney() {
    return money;
  }

  public void setMoney(BaseMoney money) {
    this.money = money;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderCustomLineItemMoneyOutput{type='" + type + "', customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', money='" + money + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderCustomLineItemMoneyOutput that = (ChangeStagedOrderCustomLineItemMoneyOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(money, that.money);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, customLineItemKey, money);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String customLineItemKey;

    private BaseMoney money;

    public ChangeStagedOrderCustomLineItemMoneyOutput build() {
      ChangeStagedOrderCustomLineItemMoneyOutput result = new ChangeStagedOrderCustomLineItemMoneyOutput();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.money = this.money;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder money(BaseMoney money) {
      this.money = money;
      return this;
    }
  }
}
