package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStagedOrderOrderState {
  private OrderState orderState;

  public ChangeStagedOrderOrderState() {
  }

  public ChangeStagedOrderOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderOrderState{orderState='" + orderState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderOrderState that = (ChangeStagedOrderOrderState) o;
    return Objects.equals(orderState, that.orderState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OrderState orderState;

    public ChangeStagedOrderOrderState build() {
      ChangeStagedOrderOrderState result = new ChangeStagedOrderOrderState();
      result.orderState = this.orderState;
      return result;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }
  }
}
