package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderOrderStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private OrderState orderState;

  public ChangeStagedOrderOrderStateOutput() {
  }

  public ChangeStagedOrderOrderStateOutput(String type, OrderState orderState) {
    this.type = type;
    this.orderState = orderState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderOrderStateOutput{type='" + type + "', orderState='" + orderState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderOrderStateOutput that = (ChangeStagedOrderOrderStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(orderState, that.orderState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, orderState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private OrderState orderState;

    public ChangeStagedOrderOrderStateOutput build() {
      ChangeStagedOrderOrderStateOutput result = new ChangeStagedOrderOrderStateOutput();
      result.type = this.type;
      result.orderState = this.orderState;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }
  }
}
