package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderShipmentStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ShipmentState shipmentState;

  public ChangeStagedOrderShipmentStateOutput() {
  }

  public ChangeStagedOrderShipmentStateOutput(String type, ShipmentState shipmentState) {
    this.type = type;
    this.shipmentState = shipmentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderShipmentStateOutput{type='" + type + "', shipmentState='" + shipmentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderShipmentStateOutput that = (ChangeStagedOrderShipmentStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shipmentState, that.shipmentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shipmentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ShipmentState shipmentState;

    public ChangeStagedOrderShipmentStateOutput build() {
      ChangeStagedOrderShipmentStateOutput result = new ChangeStagedOrderShipmentStateOutput();
      result.type = this.type;
      result.shipmentState = this.shipmentState;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }
  }
}
