package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStandalonePriceActive {
  private Boolean active;

  public ChangeStandalonePriceActive() {
  }

  public ChangeStandalonePriceActive(Boolean active) {
    this.active = active;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  @Override
  public String toString() {
    return "ChangeStandalonePriceActive{active='" + active + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStandalonePriceActive that = (ChangeStandalonePriceActive) o;
    return Objects.equals(active, that.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean active;

    public ChangeStandalonePriceActive build() {
      ChangeStandalonePriceActive result = new ChangeStandalonePriceActive();
      result.active = this.active;
      return result;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }
  }
}
