package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStateType {
  private StateType type;

  public ChangeStateType() {
  }

  public ChangeStateType(StateType type) {
    this.type = type;
  }

  public StateType getType() {
    return type;
  }

  public void setType(StateType type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ChangeStateType{type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStateType that = (ChangeStateType) o;
    return Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StateType type;

    public ChangeStateType build() {
      ChangeStateType result = new ChangeStateType();
      result.type = this.type;
      return result;
    }

    public Builder type(StateType type) {
      this.type = type;
      return this;
    }
  }
}
