package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeSubscription {
  private String resourceTypeId;

  public ChangeSubscription() {
  }

  public ChangeSubscription(String resourceTypeId) {
    this.resourceTypeId = resourceTypeId;
  }

  public String getResourceTypeId() {
    return resourceTypeId;
  }

  public void setResourceTypeId(String resourceTypeId) {
    this.resourceTypeId = resourceTypeId;
  }

  @Override
  public String toString() {
    return "ChangeSubscription{resourceTypeId='" + resourceTypeId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeSubscription that = (ChangeSubscription) o;
    return Objects.equals(resourceTypeId, that.resourceTypeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceTypeId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String resourceTypeId;

    public ChangeSubscription build() {
      ChangeSubscription result = new ChangeSubscription();
      result.resourceTypeId = this.resourceTypeId;
      return result;
    }

    public Builder resourceTypeId(String resourceTypeId) {
      this.resourceTypeId = resourceTypeId;
      return this;
    }
  }
}
