package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeSubscriptionDestination {
  private DestinationInput destination;

  public ChangeSubscriptionDestination() {
  }

  public ChangeSubscriptionDestination(DestinationInput destination) {
    this.destination = destination;
  }

  public DestinationInput getDestination() {
    return destination;
  }

  public void setDestination(DestinationInput destination) {
    this.destination = destination;
  }

  @Override
  public String toString() {
    return "ChangeSubscriptionDestination{destination='" + destination + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeSubscriptionDestination that = (ChangeSubscriptionDestination) o;
    return Objects.equals(destination, that.destination);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destination);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private DestinationInput destination;

    public ChangeSubscriptionDestination build() {
      ChangeSubscriptionDestination result = new ChangeSubscriptionDestination();
      result.destination = this.destination;
      return result;
    }

    public Builder destination(DestinationInput destination) {
      this.destination = destination;
      return this;
    }
  }
}
