package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeTypeEnumValueLabel {
  private String fieldName;

  private EnumValueInput value;

  public ChangeTypeEnumValueLabel() {
  }

  public ChangeTypeEnumValueLabel(String fieldName, EnumValueInput value) {
    this.fieldName = fieldName;
    this.value = value;
  }

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public EnumValueInput getValue() {
    return value;
  }

  public void setValue(EnumValueInput value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "ChangeTypeEnumValueLabel{fieldName='" + fieldName + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeTypeEnumValueLabel that = (ChangeTypeEnumValueLabel) o;
    return Objects.equals(fieldName, that.fieldName) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String fieldName;

    private EnumValueInput value;

    public ChangeTypeEnumValueLabel build() {
      ChangeTypeEnumValueLabel result = new ChangeTypeEnumValueLabel();
      result.fieldName = this.fieldName;
      result.value = this.value;
      return result;
    }

    public Builder fieldName(String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    public Builder value(EnumValueInput value) {
      this.value = value;
      return this;
    }
  }
}
