package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeTypeFieldDefinitionOrder {
  private List<String> fieldNames;

  public ChangeTypeFieldDefinitionOrder() {
  }

  public ChangeTypeFieldDefinitionOrder(List<String> fieldNames) {
    this.fieldNames = fieldNames;
  }

  public List<String> getFieldNames() {
    return fieldNames;
  }

  public void setFieldNames(List<String> fieldNames) {
    this.fieldNames = fieldNames;
  }

  @Override
  public String toString() {
    return "ChangeTypeFieldDefinitionOrder{fieldNames='" + fieldNames + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeTypeFieldDefinitionOrder that = (ChangeTypeFieldDefinitionOrder) o;
    return Objects.equals(fieldNames, that.fieldNames);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldNames);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> fieldNames;

    public ChangeTypeFieldDefinitionOrder build() {
      ChangeTypeFieldDefinitionOrder result = new ChangeTypeFieldDefinitionOrder();
      result.fieldNames = this.fieldNames;
      return result;
    }

    public Builder fieldNames(List<String> fieldNames) {
      this.fieldNames = fieldNames;
      return this;
    }
  }
}
