package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeTypeLabel {
  private String fieldName;

  private List<LocalizedStringItemInputType> label;

  public ChangeTypeLabel() {
  }

  public ChangeTypeLabel(String fieldName, List<LocalizedStringItemInputType> label) {
    this.fieldName = fieldName;
    this.label = label;
  }

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public List<LocalizedStringItemInputType> getLabel() {
    return label;
  }

  public void setLabel(List<LocalizedStringItemInputType> label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "ChangeTypeLabel{fieldName='" + fieldName + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeTypeLabel that = (ChangeTypeLabel) o;
    return Objects.equals(fieldName, that.fieldName) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String fieldName;

    private List<LocalizedStringItemInputType> label;

    public ChangeTypeLabel build() {
      ChangeTypeLabel result = new ChangeTypeLabel();
      result.fieldName = this.fieldName;
      result.label = this.label;
      return result;
    }

    public Builder fieldName(String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    public Builder label(List<LocalizedStringItemInputType> label) {
      this.label = label;
      return this;
    }
  }
}
