package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChannelUpdateAction {
  private AddChannelRoles addRoles;

  private ChangeChannelDescription changeDescription;

  private ChangeChannelKey changeKey;

  private ChangeChannelName changeName;

  private RemoveChannelRoles removeRoles;

  private SetChannelAddress setAddress;

  private SetChannelAddressCustomField setAddressCustomField;

  private SetChannelAddressCustomType setAddressCustomType;

  private SetChannelCustomField setCustomField;

  private SetChannelCustomType setCustomType;

  private SetChannelGeoLocation setGeoLocation;

  private SetChannelRoles setRoles;

  public ChannelUpdateAction() {
  }

  public ChannelUpdateAction(AddChannelRoles addRoles, ChangeChannelDescription changeDescription,
      ChangeChannelKey changeKey, ChangeChannelName changeName, RemoveChannelRoles removeRoles,
      SetChannelAddress setAddress, SetChannelAddressCustomField setAddressCustomField,
      SetChannelAddressCustomType setAddressCustomType, SetChannelCustomField setCustomField,
      SetChannelCustomType setCustomType, SetChannelGeoLocation setGeoLocation,
      SetChannelRoles setRoles) {
    this.addRoles = addRoles;
    this.changeDescription = changeDescription;
    this.changeKey = changeKey;
    this.changeName = changeName;
    this.removeRoles = removeRoles;
    this.setAddress = setAddress;
    this.setAddressCustomField = setAddressCustomField;
    this.setAddressCustomType = setAddressCustomType;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setGeoLocation = setGeoLocation;
    this.setRoles = setRoles;
  }

  public AddChannelRoles getAddRoles() {
    return addRoles;
  }

  public void setAddRoles(AddChannelRoles addRoles) {
    this.addRoles = addRoles;
  }

  public ChangeChannelDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeChannelDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public ChangeChannelKey getChangeKey() {
    return changeKey;
  }

  public void setChangeKey(ChangeChannelKey changeKey) {
    this.changeKey = changeKey;
  }

  public ChangeChannelName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeChannelName changeName) {
    this.changeName = changeName;
  }

  public RemoveChannelRoles getRemoveRoles() {
    return removeRoles;
  }

  public void setRemoveRoles(RemoveChannelRoles removeRoles) {
    this.removeRoles = removeRoles;
  }

  public SetChannelAddress getSetAddress() {
    return setAddress;
  }

  public void setSetAddress(SetChannelAddress setAddress) {
    this.setAddress = setAddress;
  }

  public SetChannelAddressCustomField getSetAddressCustomField() {
    return setAddressCustomField;
  }

  public void setSetAddressCustomField(SetChannelAddressCustomField setAddressCustomField) {
    this.setAddressCustomField = setAddressCustomField;
  }

  public SetChannelAddressCustomType getSetAddressCustomType() {
    return setAddressCustomType;
  }

  public void setSetAddressCustomType(SetChannelAddressCustomType setAddressCustomType) {
    this.setAddressCustomType = setAddressCustomType;
  }

  public SetChannelCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetChannelCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetChannelCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetChannelCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetChannelGeoLocation getSetGeoLocation() {
    return setGeoLocation;
  }

  public void setSetGeoLocation(SetChannelGeoLocation setGeoLocation) {
    this.setGeoLocation = setGeoLocation;
  }

  public SetChannelRoles getSetRoles() {
    return setRoles;
  }

  public void setSetRoles(SetChannelRoles setRoles) {
    this.setRoles = setRoles;
  }

  @Override
  public String toString() {
    return "ChannelUpdateAction{addRoles='" + addRoles + "', changeDescription='" + changeDescription + "', changeKey='" + changeKey + "', changeName='" + changeName + "', removeRoles='" + removeRoles + "', setAddress='" + setAddress + "', setAddressCustomField='" + setAddressCustomField + "', setAddressCustomType='" + setAddressCustomType + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setGeoLocation='" + setGeoLocation + "', setRoles='" + setRoles + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChannelUpdateAction that = (ChannelUpdateAction) o;
    return Objects.equals(addRoles, that.addRoles) &&
        Objects.equals(changeDescription, that.changeDescription) &&
        Objects.equals(changeKey, that.changeKey) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(removeRoles, that.removeRoles) &&
        Objects.equals(setAddress, that.setAddress) &&
        Objects.equals(setAddressCustomField, that.setAddressCustomField) &&
        Objects.equals(setAddressCustomType, that.setAddressCustomType) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setGeoLocation, that.setGeoLocation) &&
        Objects.equals(setRoles, that.setRoles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addRoles, changeDescription, changeKey, changeName, removeRoles, setAddress, setAddressCustomField, setAddressCustomType, setCustomField, setCustomType, setGeoLocation, setRoles);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddChannelRoles addRoles;

    private ChangeChannelDescription changeDescription;

    private ChangeChannelKey changeKey;

    private ChangeChannelName changeName;

    private RemoveChannelRoles removeRoles;

    private SetChannelAddress setAddress;

    private SetChannelAddressCustomField setAddressCustomField;

    private SetChannelAddressCustomType setAddressCustomType;

    private SetChannelCustomField setCustomField;

    private SetChannelCustomType setCustomType;

    private SetChannelGeoLocation setGeoLocation;

    private SetChannelRoles setRoles;

    public ChannelUpdateAction build() {
      ChannelUpdateAction result = new ChannelUpdateAction();
      result.addRoles = this.addRoles;
      result.changeDescription = this.changeDescription;
      result.changeKey = this.changeKey;
      result.changeName = this.changeName;
      result.removeRoles = this.removeRoles;
      result.setAddress = this.setAddress;
      result.setAddressCustomField = this.setAddressCustomField;
      result.setAddressCustomType = this.setAddressCustomType;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setGeoLocation = this.setGeoLocation;
      result.setRoles = this.setRoles;
      return result;
    }

    public Builder addRoles(AddChannelRoles addRoles) {
      this.addRoles = addRoles;
      return this;
    }

    public Builder changeDescription(ChangeChannelDescription changeDescription) {
      this.changeDescription = changeDescription;
      return this;
    }

    public Builder changeKey(ChangeChannelKey changeKey) {
      this.changeKey = changeKey;
      return this;
    }

    public Builder changeName(ChangeChannelName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder removeRoles(RemoveChannelRoles removeRoles) {
      this.removeRoles = removeRoles;
      return this;
    }

    public Builder setAddress(SetChannelAddress setAddress) {
      this.setAddress = setAddress;
      return this;
    }

    public Builder setAddressCustomField(SetChannelAddressCustomField setAddressCustomField) {
      this.setAddressCustomField = setAddressCustomField;
      return this;
    }

    public Builder setAddressCustomType(SetChannelAddressCustomType setAddressCustomType) {
      this.setAddressCustomType = setAddressCustomType;
      return this;
    }

    public Builder setCustomField(SetChannelCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetChannelCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setGeoLocation(SetChannelGeoLocation setGeoLocation) {
      this.setGeoLocation = setGeoLocation;
      return this;
    }

    public Builder setRoles(SetChannelRoles setRoles) {
      this.setRoles = setRoles;
      return this;
    }
  }
}
