package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ClassificationShippingRateInput implements com.commercetools.graphql.api.types.ShippingRateInput {
  private String key;

  private String type;

  private List<LocalizedString> labelAllLocales;

  private String label;

  public ClassificationShippingRateInput() {
  }

  public ClassificationShippingRateInput(String key, String type,
      List<LocalizedString> labelAllLocales, String label) {
    this.key = key;
    this.type = type;
    this.labelAllLocales = labelAllLocales;
    this.label = label;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<LocalizedString> getLabelAllLocales() {
    return labelAllLocales;
  }

  public void setLabelAllLocales(List<LocalizedString> labelAllLocales) {
    this.labelAllLocales = labelAllLocales;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "ClassificationShippingRateInput{key='" + key + "', type='" + type + "', labelAllLocales='" + labelAllLocales + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClassificationShippingRateInput that = (ClassificationShippingRateInput) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(type, that.type) &&
        Objects.equals(labelAllLocales, that.labelAllLocales) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, type, labelAllLocales, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String type;

    private List<LocalizedString> labelAllLocales;

    private String label;

    public ClassificationShippingRateInput build() {
      ClassificationShippingRateInput result = new ClassificationShippingRateInput();
      result.key = this.key;
      result.type = this.type;
      result.labelAllLocales = this.labelAllLocales;
      result.label = this.label;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder labelAllLocales(List<LocalizedString> labelAllLocales) {
      this.labelAllLocales = labelAllLocales;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }
  }
}
