package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CloudEventsSubscriptionsFormat implements com.commercetools.graphql.api.types.NotificationFormat {
  private String type;

  private String cloudEventsVersion;

  public CloudEventsSubscriptionsFormat() {
  }

  public CloudEventsSubscriptionsFormat(String type, String cloudEventsVersion) {
    this.type = type;
    this.cloudEventsVersion = cloudEventsVersion;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCloudEventsVersion() {
    return cloudEventsVersion;
  }

  public void setCloudEventsVersion(String cloudEventsVersion) {
    this.cloudEventsVersion = cloudEventsVersion;
  }

  @Override
  public String toString() {
    return "CloudEventsSubscriptionsFormat{type='" + type + "', cloudEventsVersion='" + cloudEventsVersion + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CloudEventsSubscriptionsFormat that = (CloudEventsSubscriptionsFormat) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(cloudEventsVersion, that.cloudEventsVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, cloudEventsVersion);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String cloudEventsVersion;

    public CloudEventsSubscriptionsFormat build() {
      CloudEventsSubscriptionsFormat result = new CloudEventsSubscriptionsFormat();
      result.type = this.type;
      result.cloudEventsVersion = this.cloudEventsVersion;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder cloudEventsVersion(String cloudEventsVersion) {
      this.cloudEventsVersion = cloudEventsVersion;
      return this;
    }
  }
}
