package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CloudEventsSubscriptionsFormatInput {
  private String cloudEventsVersion;

  public CloudEventsSubscriptionsFormatInput() {
  }

  public CloudEventsSubscriptionsFormatInput(String cloudEventsVersion) {
    this.cloudEventsVersion = cloudEventsVersion;
  }

  public String getCloudEventsVersion() {
    return cloudEventsVersion;
  }

  public void setCloudEventsVersion(String cloudEventsVersion) {
    this.cloudEventsVersion = cloudEventsVersion;
  }

  @Override
  public String toString() {
    return "CloudEventsSubscriptionsFormatInput{cloudEventsVersion='" + cloudEventsVersion + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CloudEventsSubscriptionsFormatInput that = (CloudEventsSubscriptionsFormatInput) o;
    return Objects.equals(cloudEventsVersion, that.cloudEventsVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cloudEventsVersion);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String cloudEventsVersion;

    public CloudEventsSubscriptionsFormatInput build() {
      CloudEventsSubscriptionsFormatInput result = new CloudEventsSubscriptionsFormatInput();
      result.cloudEventsVersion = this.cloudEventsVersion;
      return result;
    }

    public Builder cloudEventsVersion(String cloudEventsVersion) {
      this.cloudEventsVersion = cloudEventsVersion;
      return this;
    }
  }
}
