package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CommercetoolsSubscription implements com.commercetools.graphql.api.types.Versioned {
  private String key;

  private Destination destination;

  private List<MessageSubscription> messages;

  private List<ChangeSubscription> changes;

  private NotificationFormat format;

  private SubscriptionHealthStatus status;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public CommercetoolsSubscription() {
  }

  public CommercetoolsSubscription(String key, Destination destination,
      List<MessageSubscription> messages, List<ChangeSubscription> changes,
      NotificationFormat format, SubscriptionHealthStatus status, String id, Long version,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.key = key;
    this.destination = destination;
    this.messages = messages;
    this.changes = changes;
    this.format = format;
    this.status = status;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Destination getDestination() {
    return destination;
  }

  public void setDestination(Destination destination) {
    this.destination = destination;
  }

  public List<MessageSubscription> getMessages() {
    return messages;
  }

  public void setMessages(List<MessageSubscription> messages) {
    this.messages = messages;
  }

  public List<ChangeSubscription> getChanges() {
    return changes;
  }

  public void setChanges(List<ChangeSubscription> changes) {
    this.changes = changes;
  }

  public NotificationFormat getFormat() {
    return format;
  }

  public void setFormat(NotificationFormat format) {
    this.format = format;
  }

  public SubscriptionHealthStatus getStatus() {
    return status;
  }

  public void setStatus(SubscriptionHealthStatus status) {
    this.status = status;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "CommercetoolsSubscription{key='" + key + "', destination='" + destination + "', messages='" + messages + "', changes='" + changes + "', format='" + format + "', status='" + status + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommercetoolsSubscription that = (CommercetoolsSubscription) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(destination, that.destination) &&
        Objects.equals(messages, that.messages) &&
        Objects.equals(changes, that.changes) &&
        Objects.equals(format, that.format) &&
        Objects.equals(status, that.status) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, destination, messages, changes, format, status, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private Destination destination;

    private List<MessageSubscription> messages;

    private List<ChangeSubscription> changes;

    private NotificationFormat format;

    private SubscriptionHealthStatus status;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public CommercetoolsSubscription build() {
      CommercetoolsSubscription result = new CommercetoolsSubscription();
      result.key = this.key;
      result.destination = this.destination;
      result.messages = this.messages;
      result.changes = this.changes;
      result.format = this.format;
      result.status = this.status;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder destination(Destination destination) {
      this.destination = destination;
      return this;
    }

    public Builder messages(List<MessageSubscription> messages) {
      this.messages = messages;
      return this;
    }

    public Builder changes(List<ChangeSubscription> changes) {
      this.changes = changes;
      return this;
    }

    public Builder format(NotificationFormat format) {
      this.format = format;
      return this;
    }

    public Builder status(SubscriptionHealthStatus status) {
      this.status = status;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
