package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ConfluentCloudDestinationInput {
  private String bootstrapServer;

  private String apiKey;

  private String apiSecret;

  private String acks;

  private String topic;

  private String key;

  public ConfluentCloudDestinationInput() {
  }

  public ConfluentCloudDestinationInput(String bootstrapServer, String apiKey, String apiSecret,
      String acks, String topic, String key) {
    this.bootstrapServer = bootstrapServer;
    this.apiKey = apiKey;
    this.apiSecret = apiSecret;
    this.acks = acks;
    this.topic = topic;
    this.key = key;
  }

  public String getBootstrapServer() {
    return bootstrapServer;
  }

  public void setBootstrapServer(String bootstrapServer) {
    this.bootstrapServer = bootstrapServer;
  }

  public String getApiKey() {
    return apiKey;
  }

  public void setApiKey(String apiKey) {
    this.apiKey = apiKey;
  }

  public String getApiSecret() {
    return apiSecret;
  }

  public void setApiSecret(String apiSecret) {
    this.apiSecret = apiSecret;
  }

  public String getAcks() {
    return acks;
  }

  public void setAcks(String acks) {
    this.acks = acks;
  }

  public String getTopic() {
    return topic;
  }

  public void setTopic(String topic) {
    this.topic = topic;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "ConfluentCloudDestinationInput{bootstrapServer='" + bootstrapServer + "', apiKey='" + apiKey + "', apiSecret='" + apiSecret + "', acks='" + acks + "', topic='" + topic + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfluentCloudDestinationInput that = (ConfluentCloudDestinationInput) o;
    return Objects.equals(bootstrapServer, that.bootstrapServer) &&
        Objects.equals(apiKey, that.apiKey) &&
        Objects.equals(apiSecret, that.apiSecret) &&
        Objects.equals(acks, that.acks) &&
        Objects.equals(topic, that.topic) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bootstrapServer, apiKey, apiSecret, acks, topic, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String bootstrapServer;

    private String apiKey;

    private String apiSecret;

    private String acks;

    private String topic;

    private String key;

    public ConfluentCloudDestinationInput build() {
      ConfluentCloudDestinationInput result = new ConfluentCloudDestinationInput();
      result.bootstrapServer = this.bootstrapServer;
      result.apiKey = this.apiKey;
      result.apiSecret = this.apiSecret;
      result.acks = this.acks;
      result.topic = this.topic;
      result.key = this.key;
      return result;
    }

    public Builder bootstrapServer(String bootstrapServer) {
      this.bootstrapServer = bootstrapServer;
      return this;
    }

    public Builder apiKey(String apiKey) {
      this.apiKey = apiKey;
      return this;
    }

    public Builder apiSecret(String apiSecret) {
      this.apiSecret = apiSecret;
      return this;
    }

    public Builder acks(String acks) {
      this.acks = acks;
      return this;
    }

    public Builder topic(String topic) {
      this.topic = topic;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
