package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CountOnCustomLineItemUnitsInput {
  private String predicate;

  private Integer minCount = 1;

  private Integer maxCount;

  private Integer excludeCount;

  public CountOnCustomLineItemUnitsInput() {
  }

  public CountOnCustomLineItemUnitsInput(String predicate, Integer minCount, Integer maxCount,
      Integer excludeCount) {
    this.predicate = predicate;
    this.minCount = minCount;
    this.maxCount = maxCount;
    this.excludeCount = excludeCount;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public Integer getMinCount() {
    return minCount;
  }

  public void setMinCount(Integer minCount) {
    this.minCount = minCount;
  }

  public Integer getMaxCount() {
    return maxCount;
  }

  public void setMaxCount(Integer maxCount) {
    this.maxCount = maxCount;
  }

  public Integer getExcludeCount() {
    return excludeCount;
  }

  public void setExcludeCount(Integer excludeCount) {
    this.excludeCount = excludeCount;
  }

  @Override
  public String toString() {
    return "CountOnCustomLineItemUnitsInput{predicate='" + predicate + "', minCount='" + minCount + "', maxCount='" + maxCount + "', excludeCount='" + excludeCount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CountOnCustomLineItemUnitsInput that = (CountOnCustomLineItemUnitsInput) o;
    return Objects.equals(predicate, that.predicate) &&
        Objects.equals(minCount, that.minCount) &&
        Objects.equals(maxCount, that.maxCount) &&
        Objects.equals(excludeCount, that.excludeCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate, minCount, maxCount, excludeCount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    private Integer minCount = 1;

    private Integer maxCount;

    private Integer excludeCount;

    public CountOnCustomLineItemUnitsInput build() {
      CountOnCustomLineItemUnitsInput result = new CountOnCustomLineItemUnitsInput();
      result.predicate = this.predicate;
      result.minCount = this.minCount;
      result.maxCount = this.maxCount;
      result.excludeCount = this.excludeCount;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder minCount(Integer minCount) {
      this.minCount = minCount;
      return this;
    }

    public Builder maxCount(Integer maxCount) {
      this.maxCount = maxCount;
      return this;
    }

    public Builder excludeCount(Integer excludeCount) {
      this.excludeCount = excludeCount;
      return this;
    }
  }
}
