package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CountOnLineItemUnits implements com.commercetools.graphql.api.types.PatternComponent {
  private String predicate;

  private Integer minCount;

  private Integer maxCount;

  private Integer excludeCount;

  private String type;

  public CountOnLineItemUnits() {
  }

  public CountOnLineItemUnits(String predicate, Integer minCount, Integer maxCount,
      Integer excludeCount, String type) {
    this.predicate = predicate;
    this.minCount = minCount;
    this.maxCount = maxCount;
    this.excludeCount = excludeCount;
    this.type = type;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public Integer getMinCount() {
    return minCount;
  }

  public void setMinCount(Integer minCount) {
    this.minCount = minCount;
  }

  public Integer getMaxCount() {
    return maxCount;
  }

  public void setMaxCount(Integer maxCount) {
    this.maxCount = maxCount;
  }

  public Integer getExcludeCount() {
    return excludeCount;
  }

  public void setExcludeCount(Integer excludeCount) {
    this.excludeCount = excludeCount;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CountOnLineItemUnits{predicate='" + predicate + "', minCount='" + minCount + "', maxCount='" + maxCount + "', excludeCount='" + excludeCount + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CountOnLineItemUnits that = (CountOnLineItemUnits) o;
    return Objects.equals(predicate, that.predicate) &&
        Objects.equals(minCount, that.minCount) &&
        Objects.equals(maxCount, that.maxCount) &&
        Objects.equals(excludeCount, that.excludeCount) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate, minCount, maxCount, excludeCount, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    private Integer minCount;

    private Integer maxCount;

    private Integer excludeCount;

    private String type;

    public CountOnLineItemUnits build() {
      CountOnLineItemUnits result = new CountOnLineItemUnits();
      result.predicate = this.predicate;
      result.minCount = this.minCount;
      result.maxCount = this.maxCount;
      result.excludeCount = this.excludeCount;
      result.type = this.type;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder minCount(Integer minCount) {
      this.minCount = minCount;
      return this;
    }

    public Builder maxCount(Integer maxCount) {
      this.maxCount = maxCount;
      return this;
    }

    public Builder excludeCount(Integer excludeCount) {
      this.excludeCount = excludeCount;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
