package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CreateStandalonePrice {
  private String key;

  private String sku;

  private BaseMoneyInput value;

  private StagedPriceDraft staged;

  private String country;

  private ResourceIdentifierInput customerGroup;

  private ResourceIdentifierInput channel;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private List<ProductPriceTierInput> tiers = Collections.emptyList();

  private CustomFieldsDraft custom;

  private DiscountedProductPriceValueInput discounted;

  private Boolean active = true;

  public CreateStandalonePrice() {
  }

  public CreateStandalonePrice(String key, String sku, BaseMoneyInput value,
      StagedPriceDraft staged, String country, ResourceIdentifierInput customerGroup,
      ResourceIdentifierInput channel, OffsetDateTime validFrom, OffsetDateTime validUntil,
      List<ProductPriceTierInput> tiers, CustomFieldsDraft custom,
      DiscountedProductPriceValueInput discounted, Boolean active) {
    this.key = key;
    this.sku = sku;
    this.value = value;
    this.staged = staged;
    this.country = country;
    this.customerGroup = customerGroup;
    this.channel = channel;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.tiers = tiers;
    this.custom = custom;
    this.discounted = discounted;
    this.active = active;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public BaseMoneyInput getValue() {
    return value;
  }

  public void setValue(BaseMoneyInput value) {
    this.value = value;
  }

  public StagedPriceDraft getStaged() {
    return staged;
  }

  public void setStaged(StagedPriceDraft staged) {
    this.staged = staged;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public ResourceIdentifierInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public ResourceIdentifierInput getChannel() {
    return channel;
  }

  public void setChannel(ResourceIdentifierInput channel) {
    this.channel = channel;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public List<ProductPriceTierInput> getTiers() {
    return tiers;
  }

  public void setTiers(List<ProductPriceTierInput> tiers) {
    this.tiers = tiers;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public DiscountedProductPriceValueInput getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValueInput discounted) {
    this.discounted = discounted;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  @Override
  public String toString() {
    return "CreateStandalonePrice{key='" + key + "', sku='" + sku + "', value='" + value + "', staged='" + staged + "', country='" + country + "', customerGroup='" + customerGroup + "', channel='" + channel + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', tiers='" + tiers + "', custom='" + custom + "', discounted='" + discounted + "', active='" + active + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CreateStandalonePrice that = (CreateStandalonePrice) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(value, that.value) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(country, that.country) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(tiers, that.tiers) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(discounted, that.discounted) &&
        Objects.equals(active, that.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, sku, value, staged, country, customerGroup, channel, validFrom, validUntil, tiers, custom, discounted, active);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String sku;

    private BaseMoneyInput value;

    private StagedPriceDraft staged;

    private String country;

    private ResourceIdentifierInput customerGroup;

    private ResourceIdentifierInput channel;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private List<ProductPriceTierInput> tiers = Collections.emptyList();

    private CustomFieldsDraft custom;

    private DiscountedProductPriceValueInput discounted;

    private Boolean active = true;

    public CreateStandalonePrice build() {
      CreateStandalonePrice result = new CreateStandalonePrice();
      result.key = this.key;
      result.sku = this.sku;
      result.value = this.value;
      result.staged = this.staged;
      result.country = this.country;
      result.customerGroup = this.customerGroup;
      result.channel = this.channel;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.tiers = this.tiers;
      result.custom = this.custom;
      result.discounted = this.discounted;
      result.active = this.active;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder value(BaseMoneyInput value) {
      this.value = value;
      return this;
    }

    public Builder staged(StagedPriceDraft staged) {
      this.staged = staged;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder customerGroup(ResourceIdentifierInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder channel(ResourceIdentifierInput channel) {
      this.channel = channel;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder tiers(List<ProductPriceTierInput> tiers) {
      this.tiers = tiers;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValueInput discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }
  }
}
