package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = BooleanField.class, name = "BooleanField"),
    @JsonSubTypes.Type(value = DateField.class, name = "DateField"),
    @JsonSubTypes.Type(value = DateTimeField.class, name = "DateTimeField"),
    @JsonSubTypes.Type(value = EnumField.class, name = "EnumField"),
    @JsonSubTypes.Type(value = LocalizedEnumField.class, name = "LocalizedEnumField"),
    @JsonSubTypes.Type(value = LocalizedStringField.class, name = "LocalizedStringField"),
    @JsonSubTypes.Type(value = MoneyField.class, name = "MoneyField"),
    @JsonSubTypes.Type(value = NumberField.class, name = "NumberField"),
    @JsonSubTypes.Type(value = ReferenceField.class, name = "ReferenceField"),
    @JsonSubTypes.Type(value = StringField.class, name = "StringField"),
    @JsonSubTypes.Type(value = TimeField.class, name = "TimeField")
})
public interface CustomField {
  String getName();

  void setName(String name);
}
