package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CustomFieldsType {
  private Reference typeRef;

  private TypeDefinition type;

  /**
   * This field contains non-typed data.
   */
  private List<RawCustomField> customFieldsRaw;

  public CustomFieldsType() {
  }

  public CustomFieldsType(Reference typeRef, TypeDefinition type,
      List<RawCustomField> customFieldsRaw) {
    this.typeRef = typeRef;
    this.type = type;
    this.customFieldsRaw = customFieldsRaw;
  }

  public Reference getTypeRef() {
    return typeRef;
  }

  public void setTypeRef(Reference typeRef) {
    this.typeRef = typeRef;
  }

  public TypeDefinition getType() {
    return type;
  }

  public void setType(TypeDefinition type) {
    this.type = type;
  }

  /**
   * This field contains non-typed data.
   */
  public List<RawCustomField> getCustomFieldsRaw() {
    return customFieldsRaw;
  }

  public void setCustomFieldsRaw(List<RawCustomField> customFieldsRaw) {
    this.customFieldsRaw = customFieldsRaw;
  }

  @Override
  public String toString() {
    return "CustomFieldsType{typeRef='" + typeRef + "', type='" + type + "', customFieldsRaw='" + customFieldsRaw + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomFieldsType that = (CustomFieldsType) o;
    return Objects.equals(typeRef, that.typeRef) &&
        Objects.equals(type, that.type) &&
        Objects.equals(customFieldsRaw, that.customFieldsRaw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeRef, type, customFieldsRaw);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference typeRef;

    private TypeDefinition type;

    /**
     * This field contains non-typed data.
     */
    private List<RawCustomField> customFieldsRaw;

    public CustomFieldsType build() {
      CustomFieldsType result = new CustomFieldsType();
      result.typeRef = this.typeRef;
      result.type = this.type;
      result.customFieldsRaw = this.customFieldsRaw;
      return result;
    }

    public Builder typeRef(Reference typeRef) {
      this.typeRef = typeRef;
      return this;
    }

    public Builder type(TypeDefinition type) {
      this.type = type;
      return this;
    }

    /**
     * This field contains non-typed data.
     */
    public Builder customFieldsRaw(List<RawCustomField> customFieldsRaw) {
      this.customFieldsRaw = customFieldsRaw;
      return this;
    }
  }
}
