package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomLineItemReturnItem implements com.commercetools.graphql.api.types.ReturnItem {
  private String type;

  private String customLineItemId;

  private String id;

  private String key;

  private Long quantity;

  private String comment;

  private ReturnShipmentState shipmentState;

  private ReturnPaymentState paymentState;

  private CustomFieldsType custom;

  private OffsetDateTime lastModifiedAt;

  private OffsetDateTime createdAt;

  public CustomLineItemReturnItem() {
  }

  public CustomLineItemReturnItem(String type, String customLineItemId, String id, String key,
      Long quantity, String comment, ReturnShipmentState shipmentState,
      ReturnPaymentState paymentState, CustomFieldsType custom, OffsetDateTime lastModifiedAt,
      OffsetDateTime createdAt) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.id = id;
    this.key = key;
    this.quantity = quantity;
    this.comment = comment;
    this.shipmentState = shipmentState;
    this.paymentState = paymentState;
    this.custom = custom;
    this.lastModifiedAt = lastModifiedAt;
    this.createdAt = createdAt;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public ReturnShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ReturnShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public ReturnPaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(ReturnPaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  @Override
  public String toString() {
    return "CustomLineItemReturnItem{type='" + type + "', customLineItemId='" + customLineItemId + "', id='" + id + "', key='" + key + "', quantity='" + quantity + "', comment='" + comment + "', shipmentState='" + shipmentState + "', paymentState='" + paymentState + "', custom='" + custom + "', lastModifiedAt='" + lastModifiedAt + "', createdAt='" + createdAt + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomLineItemReturnItem that = (CustomLineItemReturnItem) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(comment, that.comment) &&
        Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(paymentState, that.paymentState) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdAt, that.createdAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, id, key, quantity, comment, shipmentState, paymentState, custom, lastModifiedAt, createdAt);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String id;

    private String key;

    private Long quantity;

    private String comment;

    private ReturnShipmentState shipmentState;

    private ReturnPaymentState paymentState;

    private CustomFieldsType custom;

    private OffsetDateTime lastModifiedAt;

    private OffsetDateTime createdAt;

    public CustomLineItemReturnItem build() {
      CustomLineItemReturnItem result = new CustomLineItemReturnItem();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.id = this.id;
      result.key = this.key;
      result.quantity = this.quantity;
      result.comment = this.comment;
      result.shipmentState = this.shipmentState;
      result.paymentState = this.paymentState;
      result.custom = this.custom;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdAt = this.createdAt;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }

    public Builder shipmentState(ReturnShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder paymentState(ReturnPaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }
  }
}
