package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomLineItemsTargetInput {
  private String predicate;

  public CustomLineItemsTargetInput() {
  }

  public CustomLineItemsTargetInput(String predicate) {
    this.predicate = predicate;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  @Override
  public String toString() {
    return "CustomLineItemsTargetInput{predicate='" + predicate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomLineItemsTargetInput that = (CustomLineItemsTargetInput) o;
    return Objects.equals(predicate, that.predicate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    public CustomLineItemsTargetInput build() {
      CustomLineItemsTargetInput result = new CustomLineItemsTargetInput();
      result.predicate = this.predicate;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }
  }
}
