package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * An input object used to create a new, or update an existing Custom Object.
 *
 * The value should be passed in a form of escaped JSON.
 *
 * Example for `value` field:
 *
 * ```
 * "{ \"stringField\": \"myVal\", \"numberField\": 123, \"boolField\": false, \"nestedObject\": { \"nestedObjectKey\": \"anotherValue\" }, \"dateField\": \"2018-10-12T14:00:00.000Z\" }"
 * ```
 */
public class CustomObjectDraft {
  private String key;

  private String container;

  /**
   * The value should be passed in a form of escaped JSON.
   *
   * Example for `value` field:
   *
   * ```
   * "{ \"stringField\": \"myVal\", \"numberField\": 123, \"boolField\": false, \"nestedObject\": { \"nestedObjectKey\": \"anotherValue\" }, \"dateField\": \"2018-10-12T14:00:00.000Z\" }"
   * ```
   */
  private String value;

  private Long version;

  public CustomObjectDraft() {
  }

  public CustomObjectDraft(String key, String container, String value, Long version) {
    this.key = key;
    this.container = container;
    this.value = value;
    this.version = version;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getContainer() {
    return container;
  }

  public void setContainer(String container) {
    this.container = container;
  }

  /**
   * The value should be passed in a form of escaped JSON.
   *
   * Example for `value` field:
   *
   * ```
   * "{ \"stringField\": \"myVal\", \"numberField\": 123, \"boolField\": false, \"nestedObject\": { \"nestedObjectKey\": \"anotherValue\" }, \"dateField\": \"2018-10-12T14:00:00.000Z\" }"
   * ```
   */
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  @Override
  public String toString() {
    return "CustomObjectDraft{key='" + key + "', container='" + container + "', value='" + value + "', version='" + version + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomObjectDraft that = (CustomObjectDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(container, that.container) &&
        Objects.equals(value, that.value) &&
        Objects.equals(version, that.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, container, value, version);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String container;

    /**
     * The value should be passed in a form of escaped JSON.
     *
     * Example for `value` field:
     *
     * ```
     * "{ \"stringField\": \"myVal\", \"numberField\": 123, \"boolField\": false, \"nestedObject\": { \"nestedObjectKey\": \"anotherValue\" }, \"dateField\": \"2018-10-12T14:00:00.000Z\" }"
     * ```
     */
    private String value;

    private Long version;

    public CustomObjectDraft build() {
      CustomObjectDraft result = new CustomObjectDraft();
      result.key = this.key;
      result.container = this.container;
      result.value = this.value;
      result.version = this.version;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder container(String container) {
      this.container = container;
      return this;
    }

    /**
     * The value should be passed in a form of escaped JSON.
     *
     * Example for `value` field:
     *
     * ```
     * "{ \"stringField\": \"myVal\", \"numberField\": 123, \"boolField\": false, \"nestedObject\": { \"nestedObjectKey\": \"anotherValue\" }, \"dateField\": \"2018-10-12T14:00:00.000Z\" }"
     * ```
     */
    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }
  }
}
