package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CustomShippingDraft {
  private String key;

  private String shippingMethodName;

  private AddressInput shippingAddress;

  private ShippingRateDraft shippingRate;

  private ShippingRateInputDraft shippingRateInput;

  private ReferenceInput taxCategory;

  private ExternalTaxRateDraft externalTaxRate;

  private List<DeliveryDraft> deliveries;

  private CustomFieldsDraft custom;

  public CustomShippingDraft() {
  }

  public CustomShippingDraft(String key, String shippingMethodName, AddressInput shippingAddress,
      ShippingRateDraft shippingRate, ShippingRateInputDraft shippingRateInput,
      ReferenceInput taxCategory, ExternalTaxRateDraft externalTaxRate,
      List<DeliveryDraft> deliveries, CustomFieldsDraft custom) {
    this.key = key;
    this.shippingMethodName = shippingMethodName;
    this.shippingAddress = shippingAddress;
    this.shippingRate = shippingRate;
    this.shippingRateInput = shippingRateInput;
    this.taxCategory = taxCategory;
    this.externalTaxRate = externalTaxRate;
    this.deliveries = deliveries;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getShippingMethodName() {
    return shippingMethodName;
  }

  public void setShippingMethodName(String shippingMethodName) {
    this.shippingMethodName = shippingMethodName;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public ShippingRateDraft getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRateDraft shippingRate) {
    this.shippingRate = shippingRate;
  }

  public ShippingRateInputDraft getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public ReferenceInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ReferenceInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public List<DeliveryDraft> getDeliveries() {
    return deliveries;
  }

  public void setDeliveries(List<DeliveryDraft> deliveries) {
    this.deliveries = deliveries;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "CustomShippingDraft{key='" + key + "', shippingMethodName='" + shippingMethodName + "', shippingAddress='" + shippingAddress + "', shippingRate='" + shippingRate + "', shippingRateInput='" + shippingRateInput + "', taxCategory='" + taxCategory + "', externalTaxRate='" + externalTaxRate + "', deliveries='" + deliveries + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomShippingDraft that = (CustomShippingDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(shippingMethodName, that.shippingMethodName) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(shippingRate, that.shippingRate) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(deliveries, that.deliveries) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, shippingMethodName, shippingAddress, shippingRate, shippingRateInput, taxCategory, externalTaxRate, deliveries, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String shippingMethodName;

    private AddressInput shippingAddress;

    private ShippingRateDraft shippingRate;

    private ShippingRateInputDraft shippingRateInput;

    private ReferenceInput taxCategory;

    private ExternalTaxRateDraft externalTaxRate;

    private List<DeliveryDraft> deliveries;

    private CustomFieldsDraft custom;

    public CustomShippingDraft build() {
      CustomShippingDraft result = new CustomShippingDraft();
      result.key = this.key;
      result.shippingMethodName = this.shippingMethodName;
      result.shippingAddress = this.shippingAddress;
      result.shippingRate = this.shippingRate;
      result.shippingRateInput = this.shippingRateInput;
      result.taxCategory = this.taxCategory;
      result.externalTaxRate = this.externalTaxRate;
      result.deliveries = this.deliveries;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder shippingMethodName(String shippingMethodName) {
      this.shippingMethodName = shippingMethodName;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder shippingRate(ShippingRateDraft shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInputDraft shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder taxCategory(ReferenceInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder deliveries(List<DeliveryDraft> deliveries) {
      this.deliveries = deliveries;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
