package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CustomSuggestTokenizerInput {
  private List<String> inputs;

  public CustomSuggestTokenizerInput() {
  }

  public CustomSuggestTokenizerInput(List<String> inputs) {
    this.inputs = inputs;
  }

  public List<String> getInputs() {
    return inputs;
  }

  public void setInputs(List<String> inputs) {
    this.inputs = inputs;
  }

  @Override
  public String toString() {
    return "CustomSuggestTokenizerInput{inputs='" + inputs + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomSuggestTokenizerInput that = (CustomSuggestTokenizerInput) o;
    return Objects.equals(inputs, that.inputs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inputs);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> inputs;

    public CustomSuggestTokenizerInput build() {
      CustomSuggestTokenizerInput result = new CustomSuggestTokenizerInput();
      result.inputs = this.inputs;
      return result;
    }

    public Builder inputs(List<String> inputs) {
      this.inputs = inputs;
      return this;
    }
  }
}
