package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerAddressCustomFieldAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private String name;

  private JsonNode value;

  private String addressId;

  private String type;

  public CustomerAddressCustomFieldAdded() {
  }

  public CustomerAddressCustomFieldAdded(String name, JsonNode value, String addressId,
      String type) {
    this.name = name;
    this.value = value;
    this.addressId = addressId;
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerAddressCustomFieldAdded{name='" + name + "', value='" + value + "', addressId='" + addressId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerAddressCustomFieldAdded that = (CustomerAddressCustomFieldAdded) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(addressId, that.addressId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, addressId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private JsonNode value;

    private String addressId;

    private String type;

    public CustomerAddressCustomFieldAdded build() {
      CustomerAddressCustomFieldAdded result = new CustomerAddressCustomFieldAdded();
      result.name = this.name;
      result.value = this.value;
      result.addressId = this.addressId;
      result.type = this.type;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
