package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerAddressCustomTypeRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private String previousTypeId;

  private String addressId;

  private String type;

  public CustomerAddressCustomTypeRemoved() {
  }

  public CustomerAddressCustomTypeRemoved(String previousTypeId, String addressId, String type) {
    this.previousTypeId = previousTypeId;
    this.addressId = addressId;
    this.type = type;
  }

  public String getPreviousTypeId() {
    return previousTypeId;
  }

  public void setPreviousTypeId(String previousTypeId) {
    this.previousTypeId = previousTypeId;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerAddressCustomTypeRemoved{previousTypeId='" + previousTypeId + "', addressId='" + addressId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerAddressCustomTypeRemoved that = (CustomerAddressCustomTypeRemoved) o;
    return Objects.equals(previousTypeId, that.previousTypeId) &&
        Objects.equals(addressId, that.addressId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(previousTypeId, addressId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String previousTypeId;

    private String addressId;

    private String type;

    public CustomerAddressCustomTypeRemoved build() {
      CustomerAddressCustomTypeRemoved result = new CustomerAddressCustomTypeRemoved();
      result.previousTypeId = this.previousTypeId;
      result.addressId = this.addressId;
      result.type = this.type;
      return result;
    }

    public Builder previousTypeId(String previousTypeId) {
      this.previousTypeId = previousTypeId;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
