package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerAddressCustomTypeSet implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomFieldsType customFields;

  private String previousTypeId;

  private String addressId;

  private String type;

  public CustomerAddressCustomTypeSet() {
  }

  public CustomerAddressCustomTypeSet(CustomFieldsType customFields, String previousTypeId,
      String addressId, String type) {
    this.customFields = customFields;
    this.previousTypeId = previousTypeId;
    this.addressId = addressId;
    this.type = type;
  }

  public CustomFieldsType getCustomFields() {
    return customFields;
  }

  public void setCustomFields(CustomFieldsType customFields) {
    this.customFields = customFields;
  }

  public String getPreviousTypeId() {
    return previousTypeId;
  }

  public void setPreviousTypeId(String previousTypeId) {
    this.previousTypeId = previousTypeId;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerAddressCustomTypeSet{customFields='" + customFields + "', previousTypeId='" + previousTypeId + "', addressId='" + addressId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerAddressCustomTypeSet that = (CustomerAddressCustomTypeSet) o;
    return Objects.equals(customFields, that.customFields) &&
        Objects.equals(previousTypeId, that.previousTypeId) &&
        Objects.equals(addressId, that.addressId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customFields, previousTypeId, addressId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomFieldsType customFields;

    private String previousTypeId;

    private String addressId;

    private String type;

    public CustomerAddressCustomTypeSet build() {
      CustomerAddressCustomTypeSet result = new CustomerAddressCustomTypeSet();
      result.customFields = this.customFields;
      result.previousTypeId = this.previousTypeId;
      result.addressId = this.addressId;
      result.type = this.type;
      return result;
    }

    public Builder customFields(CustomFieldsType customFields) {
      this.customFields = customFields;
      return this;
    }

    public Builder previousTypeId(String previousTypeId) {
      this.previousTypeId = previousTypeId;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
