package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerDateOfBirthSet implements com.commercetools.graphql.api.types.MessagePayload {
  private LocalDate dateOfBirth;

  private String type;

  public CustomerDateOfBirthSet() {
  }

  public CustomerDateOfBirthSet(LocalDate dateOfBirth, String type) {
    this.dateOfBirth = dateOfBirth;
    this.type = type;
  }

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerDateOfBirthSet{dateOfBirth='" + dateOfBirth + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerDateOfBirthSet that = (CustomerDateOfBirthSet) o;
    return Objects.equals(dateOfBirth, that.dateOfBirth) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateOfBirth, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private LocalDate dateOfBirth;

    private String type;

    public CustomerDateOfBirthSet build() {
      CustomerDateOfBirthSet result = new CustomerDateOfBirthSet();
      result.dateOfBirth = this.dateOfBirth;
      result.type = this.type;
      return result;
    }

    public Builder dateOfBirth(LocalDate dateOfBirth) {
      this.dateOfBirth = dateOfBirth;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
