package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerEmailChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private String email;

  private String type;

  public CustomerEmailChanged() {
  }

  public CustomerEmailChanged(String email, String type) {
    this.email = email;
    this.type = type;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerEmailChanged{email='" + email + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerEmailChanged that = (CustomerEmailChanged) o;
    return Objects.equals(email, that.email) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String email;

    private String type;

    public CustomerEmailChanged build() {
      CustomerEmailChanged result = new CustomerEmailChanged();
      result.email = this.email;
      result.type = this.type;
      return result;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
