package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerGroupAssignmentAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomerGroupAssignment customerGroupAssignment;

  private String type;

  public CustomerGroupAssignmentAdded() {
  }

  public CustomerGroupAssignmentAdded(CustomerGroupAssignment customerGroupAssignment,
      String type) {
    this.customerGroupAssignment = customerGroupAssignment;
    this.type = type;
  }

  public CustomerGroupAssignment getCustomerGroupAssignment() {
    return customerGroupAssignment;
  }

  public void setCustomerGroupAssignment(CustomerGroupAssignment customerGroupAssignment) {
    this.customerGroupAssignment = customerGroupAssignment;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerGroupAssignmentAdded{customerGroupAssignment='" + customerGroupAssignment + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupAssignmentAdded that = (CustomerGroupAssignmentAdded) o;
    return Objects.equals(customerGroupAssignment, that.customerGroupAssignment) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroupAssignment, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerGroupAssignment customerGroupAssignment;

    private String type;

    public CustomerGroupAssignmentAdded build() {
      CustomerGroupAssignmentAdded result = new CustomerGroupAssignmentAdded();
      result.customerGroupAssignment = this.customerGroupAssignment;
      result.type = this.type;
      return result;
    }

    public Builder customerGroupAssignment(CustomerGroupAssignment customerGroupAssignment) {
      this.customerGroupAssignment = customerGroupAssignment;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
