package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerGroupAssignmentsSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<CustomerGroupAssignment> customerGroupAssignments;

  private String type;

  public CustomerGroupAssignmentsSet() {
  }

  public CustomerGroupAssignmentsSet(List<CustomerGroupAssignment> customerGroupAssignments,
      String type) {
    this.customerGroupAssignments = customerGroupAssignments;
    this.type = type;
  }

  public List<CustomerGroupAssignment> getCustomerGroupAssignments() {
    return customerGroupAssignments;
  }

  public void setCustomerGroupAssignments(List<CustomerGroupAssignment> customerGroupAssignments) {
    this.customerGroupAssignments = customerGroupAssignments;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerGroupAssignmentsSet{customerGroupAssignments='" + customerGroupAssignments + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupAssignmentsSet that = (CustomerGroupAssignmentsSet) o;
    return Objects.equals(customerGroupAssignments, that.customerGroupAssignments) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroupAssignments, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<CustomerGroupAssignment> customerGroupAssignments;

    private String type;

    public CustomerGroupAssignmentsSet build() {
      CustomerGroupAssignmentsSet result = new CustomerGroupAssignmentsSet();
      result.customerGroupAssignments = this.customerGroupAssignments;
      result.type = this.type;
      return result;
    }

    public Builder customerGroupAssignments(
        List<CustomerGroupAssignment> customerGroupAssignments) {
      this.customerGroupAssignments = customerGroupAssignments;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
