package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerGroupCustomTypeRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private String oldTypeId;

  private String type;

  public CustomerGroupCustomTypeRemoved() {
  }

  public CustomerGroupCustomTypeRemoved(String oldTypeId, String type) {
    this.oldTypeId = oldTypeId;
    this.type = type;
  }

  public String getOldTypeId() {
    return oldTypeId;
  }

  public void setOldTypeId(String oldTypeId) {
    this.oldTypeId = oldTypeId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerGroupCustomTypeRemoved{oldTypeId='" + oldTypeId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupCustomTypeRemoved that = (CustomerGroupCustomTypeRemoved) o;
    return Objects.equals(oldTypeId, that.oldTypeId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldTypeId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String oldTypeId;

    private String type;

    public CustomerGroupCustomTypeRemoved build() {
      CustomerGroupCustomTypeRemoved result = new CustomerGroupCustomTypeRemoved();
      result.oldTypeId = this.oldTypeId;
      result.type = this.type;
      return result;
    }

    public Builder oldTypeId(String oldTypeId) {
      this.oldTypeId = oldTypeId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
