package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerGroupUpdateAction {
  private ChangeCustomerGroupName changeName;

  private SetCustomerGroupKey setKey;

  private SetCustomerGroupCustomType setCustomType;

  private SetCustomerGroupCustomField setCustomField;

  public CustomerGroupUpdateAction() {
  }

  public CustomerGroupUpdateAction(ChangeCustomerGroupName changeName, SetCustomerGroupKey setKey,
      SetCustomerGroupCustomType setCustomType, SetCustomerGroupCustomField setCustomField) {
    this.changeName = changeName;
    this.setKey = setKey;
    this.setCustomType = setCustomType;
    this.setCustomField = setCustomField;
  }

  public ChangeCustomerGroupName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeCustomerGroupName changeName) {
    this.changeName = changeName;
  }

  public SetCustomerGroupKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetCustomerGroupKey setKey) {
    this.setKey = setKey;
  }

  public SetCustomerGroupCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetCustomerGroupCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetCustomerGroupCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetCustomerGroupCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  @Override
  public String toString() {
    return "CustomerGroupUpdateAction{changeName='" + changeName + "', setKey='" + setKey + "', setCustomType='" + setCustomType + "', setCustomField='" + setCustomField + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupUpdateAction that = (CustomerGroupUpdateAction) o;
    return Objects.equals(changeName, that.changeName) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomField, that.setCustomField);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeName, setKey, setCustomType, setCustomField);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeCustomerGroupName changeName;

    private SetCustomerGroupKey setKey;

    private SetCustomerGroupCustomType setCustomType;

    private SetCustomerGroupCustomField setCustomField;

    public CustomerGroupUpdateAction build() {
      CustomerGroupUpdateAction result = new CustomerGroupUpdateAction();
      result.changeName = this.changeName;
      result.setKey = this.setKey;
      result.setCustomType = this.setCustomType;
      result.setCustomField = this.setCustomField;
      return result;
    }

    public Builder changeName(ChangeCustomerGroupName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder setKey(SetCustomerGroupKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setCustomType(SetCustomerGroupCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomField(SetCustomerGroupCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }
  }
}
