package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerLastNameSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String lastName;

  private String type;

  public CustomerLastNameSet() {
  }

  public CustomerLastNameSet(String lastName, String type) {
    this.lastName = lastName;
    this.type = type;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerLastNameSet{lastName='" + lastName + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerLastNameSet that = (CustomerLastNameSet) o;
    return Objects.equals(lastName, that.lastName) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lastName, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lastName;

    private String type;

    public CustomerLastNameSet build() {
      CustomerLastNameSet result = new CustomerLastNameSet();
      result.lastName = this.lastName;
      result.type = this.type;
      return result;
    }

    public Builder lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
